if not PersonOfHourai.settings.PersonOfHourai_HUD_Enable then
	return
end

PersonOfHourai.hud = PersonOfHourai.hud or {}

function PersonOfHourai.hud:init(name, position)
	local hud_script = managers.hud:script(PlayerBase.PLAYER_INFO_HUD_PD2)
	local in_panel = hud_script and hud_script.panel
	if alive(in_panel) then
		self._icons_atlas = "guis/dlcs/peng_lai/textures/pd2/specialization/icons_atlas"
		local hud = managers.hud:script(PlayerBase.PLAYER_INFO_HUD_PD2)
		self._poh_ui = hud.panel:panel({
			name = "person_of_hourai_ui",
			visible = true,
			w = 300,
			h = 100,
			x = PersonOfHourai.settings.poh_hud_x,
			y = PersonOfHourai.settings.poh_hud_y
		})
		
		self._poh_panel = {}
		self._poh_text = {}
		self._poh_bg = {}
		self._poh_progress = {}
		self._poh_icon = {}
		self._poh_timed = {}
		
		self:set_buffhud(
			{
				{
					panel_id = "immortal_body",
					color = Color(209	 / 255,95 / 255,238 / 255),
					text = {
						info = managers.localization:text("poh_hud_immortal_body"),
						font_size = 13
					},
					texture_rect = {64 * 2, 0, 64, 64}
				},
				{
					panel_id = "cherish_life",
					color = Color(255 / 255,218 / 255,185 / 255),
					text = {
						info = managers.localization:text("poh_hud_cherish_life"),
						font_size = 13
					},
					texture_rect = {64 * 3, 0, 64, 64},
					icon_offset_y = 2
				}
			}
		)
	end
end
	
function PersonOfHourai.hud:set_buffhud(data)
	for _, hud in ipairs(data) do
		local panel_id = hud.panel_id
		local color = hud.color
		self._poh_panel[panel_id] = self._poh_ui:panel({
			name = panel_id .. "_panel",
			w = 30,
			h = 120
		})
			
		self._poh_text[panel_id] = self._poh_panel[panel_id]:text({
			name = panel_id .. "_text",
			visible = true,
			color = color,
			font = tweak_data.hud_corner.assault_font,
			text = hud.text.info,
			layer = 1,
			vertical = "center",
			align = "center",
			font_size = hud.text.font_size,
			w = 30,
			h = 30
		})
		
		self._poh_bg[panel_id] = self._poh_panel[panel_id]:rect({
			name = panel_id .. "_bg",
			visible = true,
			color = Color.black,
			alpha = 0.3,
			w = 30,
			h = 30,	
			y = 25
		})

		self._poh_icon[panel_id] = self._poh_panel[panel_id]:bitmap({
			name = panel_id .. "_icon",
			visible = true,
			texture = self._icons_atlas,
			texture_rect = hud.texture_rect,
			color = color,
			layer = 1,
			w = self._poh_bg[panel_id]:w(),
			h = self._poh_bg[panel_id]:h(),
			x = 0 + (hud.icon_offset_x or 0),
			y = self._poh_bg[panel_id]:y() + (hud.icon_offset_y or 0)
		})
		
		self._poh_timed[panel_id] = self._poh_panel[panel_id]:text({
			name = panel_id .. "_timed",
			visible = true,
			color = color,
			font = tweak_data.hud_corner.assault_font,
			text = "time",
			layer = 1,
			vertical = "center",
			align = "center",
			font_size = 13,
			w = 30,
			h = 30,
			y = self._poh_bg[panel_id]:y() + 25
		})
	end
end
	
function PersonOfHourai.hud:set_poh_position(name, position)
	if self._poh_ui then
		if name == "poh_hud_x" then
			self._poh_ui:set_x(position)
		elseif name == "poh_hud_y" then
			self._poh_ui:set_y(position)
		end
	end
end
	
function PersonOfHourai.hud:hud_layer(layer)
	buffbox = {
		self._poh_panel["immortal_body"]:visible(),
		self._poh_panel["cherish_life"]:visible()
	}
		
	local pos_offset = 0
	for i = 1, layer do
		if buffbox[i] then
			pos_offset = pos_offset + 50
		end
	end
	
	return pos_offset - 50
end
	
function PersonOfHourai.hud:update(t, dt)
	if managers.player._Penglai_activate then
		self._poh_panel["cherish_life"]:set_visible(true)
	else
		self._poh_panel["cherish_life"]:set_visible(false)
	end
	
	self._poh_panel["cherish_life"]:set_x(PersonOfHourai.hud:hud_layer(2))
	self._poh_timed["cherish_life"]:set_text(managers.player._Penglai_t > 0 and (managers.player and string.format("%.1f", managers.player._Penglai_t)) or "")
	
	self._poh_panel["immortal_body"]:set_x(PersonOfHourai.hud:hud_layer(1))
	self._poh_timed["immortal_body"]:set_text(managers.player._immortal_body_t > 0 and (managers.player and string.format("%.1f", managers.player._immortal_body_t)) or "")
	if managers.player:has_category_upgrade("player","Penglai_health_recovery") then
		self._poh_ui:set_visible(true)
	else
		self._poh_ui:set_visible(false)
	end
end

Hooks:PostHook(HUDManager, "_setup_player_info_hud_pd2","poh_ui_init", function(self)
	PersonOfHourai.hud:init()
end)

Hooks:PostHook(HUDManager, "update","poh_ui_update", function(self, t, dt)
	PersonOfHourai.hud:update(t, dt)
end)